require( "scripts/style.lua" );


local choice1="yes";
local choice2="no" ;	
local choice3="maybe" ;	
local yloc = kCenter;

if (gDialogTable.choice1label) then
	choice1 = gDialogTable.choice1label ;
end
if (gDialogTable.choice2label) then
	choice2 = gDialogTable.choice2label ;
end
if (gDialogTable.choice3label) then
	choice3 = gDialogTable.choice3label ;
end

if (gDialogTable.yloc) then
	yloc = gDialogTable.yloc ;
end

bitmapType = Bitmap;
if (gDialogTable.popthrough and gDialogTable.popthrough == true) then
	bitmapType = PopThroughBitmap;
end

MakeDialog
{
    bitmapType
    {
        name="yesnobackground",
		image="backgrounds/small_horizontal_dialog",
		x=kCenter,
		y=yloc,
        
        SetStyle(StandardButtonStyle);
        Button
        {
			command=
				function()
					if (gDialogTable.choice1) then 
						gDialogTable.choice1() ; 
					end
				end;
            close = true,
            flags = 5,
            label = choice1,
            name = "choice1",
            x = kCenter,
            y = 50,
        },
        Button
        {
			command=
				function() 
					if (gDialogTable.choice2) then
						gDialogTable.choice2() ; 
					end
                end;
            close = true,
            flags = 5,
            label = choice2,
            name = "choice2",
            x = kCenter,
            y = 100,
        },
        
        Button
        {
			command=
				function() 
					if (gDialogTable.choice3) then
						gDialogTable.choice3() ; 
					end
                end;
            close = true,
            flags = 5,
            label = choice3,
            name = "choice3",
            x = kCenter,
            y = 150,
        },
        SetStyle(DefaultStyle);
        
        Text
		{
			font = DialogTitleFont,
			name = "yesnotitle",
			x=12, y=0,
			w=kMax,h=40,
			flags = kVAlignCenter + kHAlignLeft,
			label= gDialogTable.title,
		};
		
		Text
		{
			font = DialogBodyFont,
			name = "yesnobody",
			x=30,y=20,
			w=kMax-40,h=kMax-70,
			flags = kVAlignTop + kHAlignCenter,
			label= gDialogTable.body,
		};
		
		Text
		{
			font = DialogBodyFont,
			name = "yesnotip",
			x=50,y=270,
			w=kMax-70,h=kMax-20,
			flags = kVAlignCenter + kHAlignCenter,
			label= gDialogTable.tip,
		};
    },

} -- MakeDialog

gDialogTable.tip = "";

